// ------------------------------------
//       OnBoardC MEMO Library
//            Version 1.02
//    by: Harry Konstas May.19/2000
// ------------------------------------
 
#include "OBL.h"

CharPtr ItemsBuffer2;
 
void CloseMemo(MEMODB *pMemo)
{

  DmCloseDatabase(pMemo->db);
  MemPtrFree(pMemo);

}

MEMODB *OpenMemo(void)
{

  MEMODB *pMemo;

  pMemo = MemPtrNew(sizeof(MEMODB));

  pMemo->db = DmOpenDatabaseByTypeCreator('DATA','memo',dmModeReadWrite);
  if(pMemo->db==0) ErrDisplayFileLineMsg("MEMO I/O",0,"Error opening memo.");

  pMemo->iRec = 1;
  pMemo->RecPos = 0;
  pMemo->nRecs = DmNumRecords(pMemo->db); 

  return pMemo;

}

void NewMemo(MEMODB *pMemo, ULong size)
{

  int n;

  n = DmNumRecords(pMemo->db);
  pMemo->iRec = n;
  pMemo->h = DmNewRecord(pMemo->db,&n,size);
  pMemo->nRecs = DmNumRecords(pMemo->db); 
  pMemo->RecSize = MemHandleSize(pMemo->h);

}

int WriteMemo(MEMODB *pMemo, CharPtr text)
{

  UInt n;
  CharPtr p;

  p=MemHandleLock(pMemo->h);

  // check if enough space to write
  if(DmWriteCheck(p,pMemo->RecPos,StrLen(text)+1))
    return 0;

  // write it
  DmWrite(p,pMemo->RecPos,text,StrLen(text)+1);
  MemHandleUnlock(pMemo->h);

  n=DmNumRecords(pMemo->db)-1;
  DmReleaseRecord(pMemo->db,n,true);

  n=StrLen(text);
  pMemo->RecPos += n;
  return n;

}

int SelectMemo(MEMODB *pMemo, UInt memonum)
{

  if(memonum>=pMemo->nRecs) return 0;

  pMemo->RecSize =0;
  pMemo->iRec = memonum;
  pMemo->h = DmQueryRecord(pMemo->db,pMemo->iRec);
  if(pMemo->h!=NULL) pMemo->RecSize = MemHandleSize(pMemo->h);
  pMemo->RecPos = 0;
  return 1;

}

int ReadMemoLine(MEMODB *pMemo)
{
  int i=0;
  char c=0;
  pMemo->buffer[i]=0;

  if(pMemo->RecSize==0) return 0;

  pMemo->pData = MemHandleLock(pMemo->h);
  pMemo->pData += pMemo->RecPos;

  while(c!=0x0a && i<80) {
    if(pMemo->RecSize==pMemo->RecPos) break;
    c = *pMemo->pData;
    pMemo->buffer[i++]=c;
    pMemo->pData++; pMemo->RecPos++;
  } 

  pMemo->buffer[i]=0;
  MemHandleUnlock(pMemo->h);
  return StrLen(pMemo->buffer);
}

MEMODB *FindMemo(char *memoname)
{

  UInt f, len;
  MEMODB *pMemo;

  f=0; pMemo = OpenMemo();

  while(SelectMemo(pMemo,f++)) {
    ReadMemoLine(pMemo);
    len=StrLen(pMemo->buffer)-1;
    if(len<2) continue;
    if(StrStr(pMemo->buffer,memoname))
      return pMemo;    
  }

  CloseMemo(pMemo);
  return NULL;
}

UInt MakeMemoList(UInt ListID,char *mask)
{

  UInt i, f, len, lbnum=0, offset=0;
  MEMODB *pMemo;
  VoidHand h;
  ListPtr l;

  ItemsBuffer2 = MemPtrNew(3000);  

  f=0; pMemo = OpenMemo();

  while(SelectMemo(pMemo,f++)) {
    ReadMemoLine(pMemo);
    len=StrLen(pMemo->buffer)-1;
    if(len<2) continue;
  
    if(StrLen(mask)==0||StrStr(pMemo->buffer,mask)) {
      for(i=0;i<len;i++) 
        ItemsBuffer2[offset+i] = pMemo->buffer[i];

      offset+=len;if(offset>2900) break;
      ItemsBuffer2[offset++]=0;lbnum++; 
    }
  }

  CloseMemo(pMemo);

  if(lbnum) {
    l=GetObjectPtr(ListID);
    h=SysFormPointerArrayToStrings(ItemsBuffer2,lbnum);
    LstSetListChoices(l,MemHandleLock(h),lbnum);
    LstSetSelection(l,0);
    LstMakeItemVisible(l,0);
    MemHandleUnlock(h);
  }

  return lbnum;

}

void DiscardMemoList(void)
{
  MemPtrFree(ItemsBuffer2); 
}
